@component('admin.components.card')
    @slot('title', __('Other'))
    @slot('class', 'pb-0')

    <div class="row">
        <div class="col-12 form-group">
            <label class="form-control-label" for="admin-notification_emails">{{ __('Emails for Admin Notifications') }} <sup class="text-danger">*</sup></label>
            <small class="form-text text-muted mt-0 mb-3">{{ __('Separate the emails by using a comma (,) or a new line. Invalid emails will just be ignored.') }}</small>
            <div class="{{ $errors->has('admin-notification_emails') ? 'has-danger' : '' }}">
                <textarea name="admin-notification_emails" id="admin-notification_emails" class="form-control {{ $errors->has('admin-notification_emails') ? 'is-invalid' : '' }}" placeholder="{{ __('Emails for Admin Notifications') }}" rows="5" required>{{ old('admin-notification_emails', config('admin.notification_emails')) }}</textarea>
            </div>
            @include('alerts.feedback', ['field' => 'admin-notification_emails'])
        </div>
    </div>
@endcomponent
