@component('admin.components.card')
    @slot('title', __('Maintenance Mode'))
    @slot('class', 'pb-0')

    <div class="row">
        <div class="col-12 form-group">
            <label class="form-control-label" for="app-maintenance_mode_status">{{ __('Status') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('app-maintenance_mode_status') ? 'has-danger' : '' }}">
                <select class="form-control {{ $errors->has('app-maintenance_mode_status') ? 'is-invalid' : '' }}" name="app-maintenance_mode_status" id="app-maintenance_mode_status" required>
                    <option value="enable" @if (app()->isDownForMaintenance()) selected @endif>{{ __('Enable') }}</option>
                    <option value="disable" @if (!app()->isDownForMaintenance()) selected @endif>{{ __('Disable') }}</option>
                </select>
            </div>
            @include('alerts.feedback', ['field' => 'app-maintenance_mode_status'])
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="app-maintenance_mode_message">{{ __('Message') }} <sup class="text-danger">*</sup></label>
            <small class="form-text text-muted mt-0 mb-3">{{ __('Message to be display to the end-user in the maintenance page.') }}</small>
            <div class="{{ $errors->has('app-maintenance_mode_message') ? 'has-danger' : '' }}">
                <textarea name="app-maintenance_mode_message" id="app-maintenance_mode_message" class="form-control {{ $errors->has('app-maintenance_mode_message') ? 'is-invalid' : '' }}" placeholder="{{ __('Message') }}" rows="5">{{ old('app-maintenance_mode_message', config('app.maintenance_mode_message')) }}</textarea>
            </div>
            @include('alerts.feedback', ['field' => 'app-maintenance_mode_message'])
        </div>
    </div>
@endcomponent
