@component('admin.components.card')
    @slot('title', __('General'))
    @slot('class', 'pb-0')

    <div class="row">
        @include('admin.components.fileinput', [
            'thumbnail' => [
                'delete' => uno()->logo_path != uno()->default_logo_path,
                'class' => 'col-sm-5 mb-3 form-group',
                'label' => 'logo',
                'url' => uno()->logo,
                'path' => uno()->logo_path,
                'policy' => 'update',
                'entity' => \App\Model\Setting::class,
            ],
            'label' => 'Website Logo',
            'name' => 'app-logo',
            'recommend' => '350px * 150px',
        ])

        <div class="col-12 form-group">
            <label class="form-control-label" for="app-name">{{ __('Website Title/Name') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('app-name') ? 'has-danger' : '' }}">
                <input type="text" name="app-name" id="app-name" class="form-control {{ $errors->has('app-name') ? 'is-invalid' : '' }}" placeholder="{{ __('Website Title/Name') }}" value="{{ old('app-name', config('app.name')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'app-name'])
        </div>

        {{-- <div class="col-12 form-group">
            <label class="form-control-label" for="app-description">{{ __('Website Description') }}</label>
            <div class="{{ $errors->has('app-description') ? 'has-danger' : '' }}">
                <textarea name="app-description" id="app-description" class="form-control {{ $errors->has('app-description') ? 'is-invalid' : '' }}" placeholder="{{ __('Website Description') }}" rows="5">{{ old('app-description', config('app.description')) }}</textarea>
            </div>
            @include('alerts.feedback', ['field' => 'app-description'])
        </div> --}}

        {{-- <div class="col-12 form-group">
            <label class="form-control-label" for="app-keywords">{{ __('Website Keywords') }}</label>
            <div class="{{ $errors->has('app-keywords') ? 'has-danger' : '' }}">
                <textarea name="app-keywords" id="app-keywords" class="form-control {{ $errors->has('app-keywords') ? 'is-invalid' : '' }}" placeholder="{{ __('Website Keywords') }}" rows="5">{{ old('app-keywords', config('app.keywords')) }}</textarea>
            </div>
            @include('alerts.feedback', ['field' => 'app-keywords'])
        </div> --}}

        <div class="col-12 form-group">
            <label class="form-control-label" for="app-mobile-version-android">{{ __('Android Current App Version') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('app-mobile-version-android') ? 'has-danger' : '' }}">
                <input type="text" name="app-mobile-version-android" id="app-mobile-version-android" class="form-control {{ $errors->has('app-mobile-version-android') ? 'is-invalid' : '' }}" placeholder="{{ __('Android Current App Version') }}" value="{{ old('app-mobile-version-android', config('app.mobile.version.android', '1.0.0')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'app-mobile-version-android'])
        </div>

        <div class="col-12 form-group">
            <label class="form-control-label" for="app-mobile-version-ios">{{ __('iOS Current App Version') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('app-mobile-version-ios') ? 'has-danger' : '' }}">
                <input type="text" name="app-mobile-version-ios" id="app-mobile-version-ios" class="form-control {{ $errors->has('app-mobile-version-ios') ? 'is-invalid' : '' }}" placeholder="{{ __('iOS Current App Version') }}" value="{{ old('app-mobile-version-ios', config('app.mobile.version.ios', '1.0.0')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'app-mobile-version-ios'])
        </div>
    </div>
@endcomponent
