@inject('setting_entity', App\Model\Setting::class)

@extends('admin.layouts.base', [
    'title' => __('Settings Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-tools fa-lg"></i>
        @endslot

        <li class="breadcrumb-item active" aria-current="page">{{ __('Settings') }}</li>
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @if (app()->isDownForMaintenance())
                    <div class="alert alert-secondary shadow mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-circle-exclamation text-danger fa-lg"></i>
                            <strong class="px-3">{{ __('MAINTENANCE MODE') }}:</strong>
                            @if (config('app.maintenance_mode_message'))
                                <strong class="pr-3 mr-auto">[ {{ config('app.maintenance_mode_message') }} ]</strong>
                            @endif
                            <span class="badge badge-pill badge-success badge-lg">{{ __('ENABLED') }}</span>
                        </div>
                    </div>
                @endif
                <form action="{{ route('setting.update') }}" method="post" autocomplete="off" enctype="multipart/form-data">
                    @method('put')
                    @csrf

                    <div class="row">
                        <div class="col-12">
                            <div class="card card-form shadow">
                                <div class="card-body text-center">
                                    <button type="submit" class="btn btn-success px-5"><i class="fas fa-save mr-2"></i>{{ __('Save All') }}</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            @include('admin.setting.module.general')
                            @include('admin.setting.module.smtp')
                        </div>
                        <div class="col-xl-6">
                            @include('admin.setting.module.recaptcha')
                            @include('admin.setting.module.maintenance')
                            @include('admin.setting.module.other')
                        </div>
                        <div class="col-12">
                            <div class="card card-form shadow">
                                <div class="card-body text-center">
                                    <button type="submit" class="btn btn-success px-5"><i class="fas fa-save mr-2"></i>{{ __('Save All') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}" nonce="{{ csp_nonce('style') }}">
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush
