@inject('user', Modules\User\Entities\User::class)

@php
    $route_active = route_active('user.*') ? 'active' : '';
@endphp

@can('view-any', $user)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarUsers" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarUsers">
            <i class="fas fa-user-tie text-primary"></i>
            <span class="nav-link-text">{{ __('Users') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarUsers">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('user.index') ?: 'active text-primary' }}" href="{{ route('user.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $user)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('user.create') ?: 'active text-primary' }}" href="{{ route('user.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $user)
                    @if (route_is_equal('user.edit') && ($entity = request()->route()->user))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('user.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $user)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('user.trashed') ?: 'active text-primary' }}" href="{{ route('user.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
