@inject('static_page', App\Model\StaticPage::class)

@can('view-any', $static_page)
    <li class="nav-item">
        <a class="nav-link {{ route_active('static-page.*') }}" href="#navbarStaticPage" data-toggle="collapse" role="button" aria-expanded="{{ route_active('static-page.*') ? 'true' : 'false' }}" aria-controls="navbarStaticPage">
            <i class="fas fa-pager text-primary"></i>
            <span class="nav-link-text">{{ __('Pages') }}</span>
        </a>
        <div class="collapse {{ !route_active('static-page.*') ?: 'show' }}" id="navbarStaticPage">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('static-page.index') ?: 'active text-primary' }}" href="{{ route('static-page.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $static_page)
                    {{-- <li class="nav-item">
                        <a class="nav-link {{ !route_active('static-page.menus') ?: 'active text-primary' }}" href="{{ route('static-page.menus') }}">
                            <i class="fas fa-sitemap"></i>
                            <span class="nav-link-text">{{ __('Menus') }}</span>
                        </a>
                    </li> --}}
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('static-page.create') ?: 'active text-primary' }}" href="{{ route('static-page.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $static_page)
                    @if (route_is_equal('static-page.edit') && ($entity = request()->route()->static_page))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('static-page.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $static_page)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('static-page.trashed') ?: 'active text-primary' }}" href="{{ route('static-page.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
