@inject('speaker', Modules\Speaker\Entities\Speaker::class)

@php
    $route_active = route_active('speaker.*') ? 'active' : '';
@endphp

@can('view-any', $speaker)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarSpeakers" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarSpeakers">
            <i class="fas fa-user-graduate text-primary"></i>
            <span class="nav-link-text">{{ __('Speakers') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarSpeakers">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('speaker.index') ?: 'active text-primary' }}" href="{{ route('speaker.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $speaker)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('speaker.create') ?: 'active text-primary' }}" href="{{ route('speaker.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $speaker)
                    @if (route_is_equal('speaker.edit') && ($entity = request()->route()->speaker))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('speaker.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $speaker)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('speaker.trashed') ?: 'active text-primary' }}" href="{{ route('speaker.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
