@inject('report', Modules\Report\Entities\Report::class)

@php
    $route_active = route_active('report.*') ? 'active' : '';
    $report_types = $report::typeList();
@endphp

@can('view-any', $report)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarReports" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarReports">
            <i class="fas fa-chart-pie text-primary"></i>
            <span class="nav-link-text">{{ __('Reports') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarReports">
            <ul class="nav nav-sm flex-column">
                @foreach ($report_types as $slug)
                    <li class="nav-item">
                        <a class="nav-link {{ route_active('report.index') && request()->route()->slug == $slug ? 'active text-primary' : '' }}" href="{{ route('report.index', $slug) }}">
                            <i class="fas fa-list"></i>
                            <span class="nav-link-text">{{ ucfirst($slug) }} {{ __('Report') }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    </li>
@endcan
