@inject('participant', Modules\Participant\Entities\Participant::class)

@php
    $route_active = route_active('participant.*') ? 'active' : '';
@endphp

@can('view-any', $participant)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarParticipants" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarParticipants">
            <i class="fas fa-user-group text-primary"></i>
            <span class="nav-link-text">{{ __('Participants') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarParticipants">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('participant.index') ?: 'active text-primary' }}" href="{{ route('participant.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $participant)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('participant.create') ?: 'active text-primary' }}" href="{{ route('participant.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $participant)
                    @if (route_is_equal('participant.edit') && ($entity = request()->route()->participant))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('participant.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $participant)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('participant.trashed') ?: 'active text-primary' }}" href="{{ route('participant.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
