@inject('feedback', Modules\Feedback\Entities\Feedback::class)

@php
    $route_active = route_active('feedback.*') ? 'active' : '';
@endphp

@can('view-any', $feedback)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarFeedbacks" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarFeedbacks">
            <i class="fas fa-comments text-primary"></i>
            <span class="nav-link-text">{{ __('Feedbacks') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarFeedbacks">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('feedback.index') ?: 'active text-primary' }}" href="{{ route('feedback.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $feedback)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('feedback.create') ?: 'active text-primary' }}" href="{{ route('feedback.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $feedback)
                    @if (route_is_equal('feedback.edit') && ($entity = request()->route()->feedback))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('feedback.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $feedback)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('feedback.trashed') ?: 'active text-primary' }}" href="{{ route('feedback.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
