@inject('event', Modules\Event\Entities\Event::class)

@php
    $route_active = route_active('event.*') ? 'active' : '';
@endphp

@can('view-any', $event)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarEvents" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarEvents">
            <i class="fas fa-calendar-day text-primary"></i>
            <span class="nav-link-text">{{ __('Events') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarEvents">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('event.index') ?: 'active text-primary' }}" href="{{ route('event.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $event)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('event.create') ?: 'active text-primary' }}" href="{{ route('event.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @if (route_is_equal('event.gallery.index') && ($entity = request()->route()->event))
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('event.gallery.index') ?: 'active text-primary' }}">
                            <i class="fas fa-photo-film"></i>
                            <span class="nav-link-text">{{ __('Gallery #:id', ['id' => is_object($entity) ? $entity?->id : '']) }}</span>
                        </a>
                    </li>
                @endif
                @if (route_is_equal('event.schedule.index') && ($entity = request()->route()->event))
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('event.schedule.index') ?: 'active text-primary' }}">
                            <i class="fas fa-clock"></i>
                            <span class="nav-link-text">{{ __('Schedule #:id', ['id' => is_object($entity) ? $entity?->id : '']) }}</span>
                        </a>
                    </li>
                @endif
                @if (route_is_equal('event.users.index') && ($entity = request()->route()->event))
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('event.users.index') ?: 'active text-primary' }}">
                            <i class="fas fa-user-group"></i>
                            <span class="nav-link-text">{{ __('Participants #:id', ['id' => is_object($entity) ? $entity?->id : '']) }}</span>
                        </a>
                    </li>
                @endif
                @can('update', $event)
                    @if (route_is_equal('event.edit') && ($entity = request()->route()->event))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('event.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => is_object($entity) ? $entity?->id : '']) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $event)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('event.trashed') ?: 'active text-primary' }}" href="{{ route('event.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
