@inject('country', Modules\Country\Entities\Country::class)

@php
    $route_active = route_active('country.*') ? 'active' : '';
@endphp

@can('view-any', $country)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarCountries" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarCountries">
            <i class="fas fa-earth-americas text-primary"></i>
            <span class="nav-link-text">{{ __('Countries') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarCountries">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('country.index') ?: 'active text-primary' }}" href="{{ route('country.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $country)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('country.create') ?: 'active text-primary' }}" href="{{ route('country.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $country)
                    @if (route_is_equal('country.edit') && ($entity = request()->route()->country))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('country.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $country)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('country.trashed') ?: 'active text-primary' }}" href="{{ route('country.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
