@inject('block', Modules\Block\Entities\Block::class)

@php
    $route_active = route_active('block.*') ? 'active' : '';
@endphp

@can('view-any', $block)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarBlocks" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarBlocks">
            <i class="fas fa-shapes text-primary"></i>
            <span class="nav-link-text">{{ __('Content Blocks') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarBlocks">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('block.index') ?: 'active text-primary' }}" href="{{ route('block.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $block)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('block.create') ?: 'active text-primary' }}" href="{{ route('block.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $block)
                    @if (route_is_equal('block.edit') && ($entity = request()->route()->block))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('block.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $block)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('block.trashed') ?: 'active text-primary' }}" href="{{ route('block.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
