@inject('banner', App\Model\Banner::class)

@can('view-any', $banner)
    <li class="nav-item">
        <a class="nav-link {{ route_active('banner.*') }}" href="#navbarBanner" data-toggle="collapse" role="button" aria-expanded="{{ route_active('banner.*') ? 'true' : 'false' }}" aria-controls="navbarBanner">
            <i class="fas fa-images text-primary"></i>
            <span class="nav-link-text">{{ __('Banners') }}</span>
        </a>
        <div class="collapse {{ !route_active('banner.*') ?: 'show' }}" id="navbarBanner">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('banner.index') ?: 'active text-primary' }}" href="{{ route('banner.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $banner)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('banner.create') ?: 'active text-primary' }}" href="{{ route('banner.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Add New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $banner)
                    @if (route_is_equal('banner.edit') && ($entity = request()->route()->banner))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('banner.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $banner)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('banner.trashed') ?: 'active text-primary' }}" href="{{ route('banner.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
