@inject('announcement', Modules\Announcement\Entities\Announcement::class)

@php
    $route_active = route_active('announcement.*') ? 'active' : '';
@endphp

@can('view-any', $announcement)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarAnnouncements" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarAnnouncements">
            <i class="fas fa-bullhorn text-primary"></i>
            <span class="nav-link-text">{{ __('Announcements') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarAnnouncements">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('announcement.index') ?: 'active text-primary' }}" href="{{ route('announcement.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $announcement)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('announcement.create') ?: 'active text-primary' }}" href="{{ route('announcement.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $announcement)
                    @if (route_is_equal('announcement.edit') && ($entity = request()->route()->announcement))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('announcement.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $announcement)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('announcement.trashed') ?: 'active text-primary' }}" href="{{ route('announcement.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
