@inject('admin', Modules\Admin\Entities\Admin::class)

@php
    $route_active = route_active('admin.*') ? 'active' : '';
@endphp

@can('view-any', $admin)
    <li class="nav-item">
        <a class="nav-link {{ $route_active }}" href="#navbarAdmins" data-toggle="collapse" role="button" aria-expanded="{{ $route_active ? 'true' : 'false' }}" aria-controls="navbarAdmins">
            <i class="fas fa-user-cog text-primary"></i>
            <span class="nav-link-text">{{ __('Admins') }}</span>
        </a>
        <div class="collapse {{ !$route_active ?: 'show' }}" id="navbarAdmins">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ !route_active('admin.index') ?: 'active text-primary' }}" href="{{ route('admin.index') }}">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text">{{ __('List All') }}</span>
                    </a>
                </li>
                @can('create', $admin)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('admin.create') ?: 'active text-primary' }}" href="{{ route('admin.create') }}">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text">{{ __('Create New') }}</span>
                        </a>
                    </li>
                @endcan
                @can('update', $admin)
                    @if (route_is_equal('admin.edit') && ($entity = request()->route()->admin))
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('admin.edit') ?: 'active text-primary' }}">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text">{{ __('Edit #:id', ['id' => $entity?->id]) }}</span>
                            </a>
                        </li>
                    @endif
                @endcan
                @can('restore', $admin)
                    <li class="nav-item">
                        <a class="nav-link {{ !route_active('admin.trashed') ?: 'active text-primary' }}" href="{{ route('admin.trashed') }}">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text">{{ __('Trashed') }}</span>
                        </a>
                    </li>
                @endcan
            </ul>
        </div>
    </li>
@endcan
