@inject('audit_login_entity', App\Model\AuditLogin::class)
@inject('setting_entity', App\Model\Setting::class)

<nav class="sidenav navbar navbar-vertical fixed-left navbar-expand-xs navbar-light bg-white" id="sidenav-main">
    <div class="scrollbar-inner scroll-scrollx_visible">
        <div class="sidenav-header d-flex align-items-center">
            <a class="navbar-brand" href="{{ route('home') }}">
                <img src="{{ uno()->logo }}" class="navbar-brand-img" alt="logo">
            </a>
            <div class="ml-auto">
                <div class="sidenav-toggler d-none d-xl-block" data-action="sidenav-unpin" data-target="#sidenav-main">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar-inner">
            <div class="collapse navbar-collapse" id="sidenav-collapse-main">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link {{ route_active('home') }}" href="{{ route('home') }}">
                            <i class="fas fa-home text-primary"></i>
                            <span class="nav-link-text">{{ __('Dashboard') }}</span>
                        </a>
                    </li>
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted">{{ __('Modules') }}</h6>
                <ul class="navbar-nav mb-md-3">
                    {{-- @includeWhen(module_enabled('Country'), 'admin.layouts.navbars.sidebar.countries') --}}
                    @includeWhen(module_enabled('Event'), 'admin.layouts.navbars.sidebar.events')
                    @includeWhen(module_enabled('Feedback'), 'admin.layouts.navbars.sidebar.feedbacks')
                    @includeWhen(module_enabled('Announcement'), 'admin.layouts.navbars.sidebar.announcements')
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted">{{ __('Users') }}</h6>
                <ul class="navbar-nav mb-md-3">
                    @includeWhen(module_enabled('Admin'), 'admin.layouts.navbars.sidebar.admins')
                    @includeWhen(module_enabled('User'), 'admin.layouts.navbars.sidebar.users')
                    @includeWhen(module_enabled('Speaker'), 'admin.layouts.navbars.sidebar.speakers')
                    @includeWhen(module_enabled('Participant'), 'admin.layouts.navbars.sidebar.participants')
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted">{{ __('System') }}</h6>
                <ul class="navbar-nav mb-md-3">
                    {{-- @includeWhen(module_enabled('Block'), 'admin.layouts.navbars.sidebar.blocks') --}}
                    @include('admin.layouts.navbars.sidebar.banners')
                    @include('admin.layouts.navbars.sidebar.staticpages')
                    @can('view-any', $audit_login_entity)
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('audit-login.index') ?: 'active text-primary' }}" href="{{ route('audit-login.index') }}">
                                <i class="fas fa-user-lock text-primary"></i>
                                <span class="nav-link-text">{{ __('Audit Logins') }}</span>
                            </a>
                        </li>
                    @endcan
                    @can('view-any', $setting_entity)
                        <li class="nav-item">
                            <a class="nav-link {{ !route_active('setting.index') ?: 'active text-primary' }}" href="{{ route('setting.index') }}">
                                <i class="fas fa-tools text-primary"></i>
                                <span class="nav-link-text">{{ __('Settings') }}</span>
                            </a>
                        </li>
                    @endcan
                    <li class="nav-item">
                        <a class="nav-link">
                            <i class="fas fa-tag"></i>
                            <span class="nav-link-text">{{ config('app.version') }}</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
