<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $title ?? 'Admin Dashboard' }} | {{ config('app.name') }}</title>

        <!-- Favicon -->
        <link href="{{ uno()->favicon }}" rel="icon" type="image/png">

        <!-- Icons CSS -->
    	<link type="text/css" href="{{ basset_url('css/icons.css') }}" rel="stylesheet">

        @stack('vendor-css')

        <!-- Argon CSS -->
        <link type="text/css" href="{{ basset_url('css/argon.css', mix: true) }}" rel="stylesheet">

        @stack('css')
    </head>
    <body class="{{ $class ?? '' }}">
        @auth()
            <form id="logoutForm" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
            @include('admin.layouts.navbars.sidebar')
        @endauth

        <div class="main-content d-flex flex-column vh-100">
            @if ($nav ?? true)
                @include('admin.layouts.navbars.navbar')
            @endif

            @if ($header ?? true)
                @include('admin.layouts.headers.header')
            @endif

            @yield('content')

            @if ($footer ?? true)
                @include('admin.layouts.footers.nav')
            @endif
        </div>

        @if (!app()->isProduction() && config('clockwork.enable'))
            <div class="fixed-bottom sidenav">
                <a class="btn btn-dark m-3 px-3" href="{{ url('clockwork/app') }}" target="_blank" role="button" title="Clockwork">
                    <i class="fas fa-cogs"></i>
                </a>
            </div>
            <script src="{{ basset_url('https://cdn.jsdelivr.net/gh/underground-works/clockwork-browser@1/dist/metrics.js') }}" nonce="{{ csp_nonce('script') }}"></script>
        @endif

        @stack('modals')

        <!-- Scripts -->
    	<script src="{{ basset_url('js/manifest.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    	<script src="{{ basset_url('js/vendor_jquery.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    	<script src="{{ basset_url('js/vendor_admin.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    	<script src="{{ basset_url('js/app.js') }}" nonce="{{ csp_nonce('script') }}"></script>

    	<script src="{{ basset_url('argon/vendor/js-cookie/js.cookie.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    	<script src="{{ basset_url('argon/vendor/jquery.scrollbar/jquery.scrollbar.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    	<script src="{{ basset_url('argon/vendor/jquery-scroll-lock/dist/jquery-scrollLock.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>

        @stack('vendor-js')

        <!-- Argon JS -->
        <script src="{{ basset_url('js/argon.js', mix: true) }}" nonce="{{ csp_nonce('script') }}"></script>

        @bassetBlock('admin/js/elfinder-selected-file.js')
            <script nonce="{{ basset_nonce('script') }}">
                window.processELFinderSelectedFile = function (filePath, requestingFieldName) {
                    $('#' + requestingFieldName + 'ElFinderFileInput').next().html(filePath);
                    $('#' + requestingFieldName + 'ElFinderFileInput').parent().append(`<input type="hidden" name="${requestingFieldName}" value="${filePath}">`);
                };
            </script>
        @endBassetBlock()

        @bassetBlock('admin/js/submit-confirmation.js')
            <script nonce="{{ basset_nonce('script') }}">
                window.listenFormNeedConfirmation = function () {
                    $('.need-confirm').on('submit', function (ev) {
                        let button = $(this).find('button[type=submit]');

                        if (confirm("{{ __('Are you sure to proceed with this action?') }}")) {
                            button.html('<i class="fas fa-arrows-rotate fa-spin"></i>').prop('disabled', true);
                        } else {
                            ev.preventDefault();

                            if (button.hasClass('btn-trash')) {
                                console.log(123456);

                                button.html('<i class="fas fa-trash"></i>').prop('disabled', false);
                            }
                        }
                    });
                }

                listenFormNeedConfirmation();
            </script>
        @endBassetBlock()

        @stack('js')
    </body>
</html>
