@extends('admin.layouts.base', [
    'title' => __('Dashboard'),
])

@section('header')
    @if (app()->isDownForMaintenance())
        <div class="alert alert-secondary shadow mb--3 mt-4" role="alert">
            <div class="d-flex align-items-center">
                <i class="fas fa-circle-exclamation text-danger fa-lg"></i>
                <strong class="px-3">{{ __('MAINTENANCE MODE') }}:</strong>
                @if (config('app.maintenance_mode_message'))
                    <strong class="pr-3 mr-auto">[ {{ config('app.maintenance_mode_message') }} ]</strong>
                @endif
                <span class="badge badge-pill badge-success badge-lg">{{ __('ENABLED') }}</span>
            </div>
        </div>
    @endif

    <div class="mb--4 mt-4">
        @include('alerts.success')
        @include('alerts.errors')
    </div>

    <div class="row pt-3 mb--6">
        <div class="col-12">
            <h1 class="display-2 text-white mb-3">{{ __('Modules') }}</h1>
        </div>

        @if (module_enabled('Event'))
            @php
                $events = \Modules\Event\Entities\Event::latest()->get();
            @endphp

            @include('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Events'),
                'query' => $events->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-calendar-day'
            ])

            @include('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Events'),
                'query' => $events->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-calendar-day'
            ])

            @include('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['featured' => 'yes'],
                'label' => __('Total Featured Events'),
                'query' => $events->where('is_featured', true),
                'color' => 'tertiary',
                'icon' => 'fa-calendar-day'
            ])
        @endif

        @if (module_enabled('Feedback'))
            @php
                $feedbacks = \Modules\Feedback\Entities\Feedback::latest()->get();
            @endphp

            @include('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_APPROVED],
                'label' => __('Total Approved Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'success',
                'icon' => 'fa-comments'
            ])

            @include('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_DISABLED],
                'label' => __('Total Disabled Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'danger',
                'icon' => 'fa-comments'
            ])

            @include('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_PENDING],
                'label' => __('Total Pending Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'tertiary',
                'icon' => 'fa-comments'
            ])
        @endif

        @if (module_enabled('Announcement'))
            @php
                $announcements = \Modules\Announcement\Entities\Announcement::latest()->get();
            @endphp

            @include('admin.components.panel', [
                'route' => 'announcement.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Announcements'),
                'query' => $announcements->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-bullhorn'
            ])

            @include('admin.components.panel', [
                'route' => 'announcement.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Announcements'),
                'query' => $announcements->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-bullhorn'
            ])
        @endif

        <div class="col-12">
            <h1 class="display-2 text-white mb-3">{{ __('Users') }}</h1>
        </div>

        @if (module_enabled('Admin'))
            @php
                $admins = \Modules\Admin\Entities\Admin::withTrashed()->latest()->get();
            @endphp

            @include('admin.components.panel', [
                'route' => 'admin.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Admins'),
                'query' => $admins->whereNull('deleted_at')->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-user-cog'
            ])

            @include('admin.components.panel', [
                'route' => 'admin.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Admins'),
                'query' => $admins->whereNull('deleted_at')->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-user-cog'
            ])

            @include('admin.components.panel', [
                'route' => 'admin.trashed',
                'params' => [],
                'label' => __('Total Trashed Admins'),
                'query' => $admins->whereNotNull('deleted_at'),
                'color' => 'tertiary',
                'icon' => 'fa-user-cog'
            ])
        @endif

        @if (module_enabled('Speaker'))
            @php
                $speakers = \Modules\Speaker\Entities\Speaker::withTrashed()->latest()->get();
            @endphp

            @include('admin.components.panel', [
                'route' => 'speaker.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Speakers'),
                'query' => $speakers->whereNull('deleted_at')->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-user-graduate'
            ])

            @include('admin.components.panel', [
                'route' => 'speaker.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Speakers'),
                'query' => $speakers->whereNull('deleted_at')->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-user-graduate'
            ])

            @include('admin.components.panel', [
                'route' => 'speaker.trashed',
                'params' => [],
                'label' => __('Total Trashed Speakers'),
                'query' => $speakers->whereNotNull('deleted_at'),
                'color' => 'tertiary',
                'icon' => 'fa-user-graduate'
            ])
        @endif

        @includeWhen(module_enabled('Participant'), 'admin.components.panel', [
            'route' => 'participant.index',
            'params' => [],
            'label' => __('Total Participants'),
            'query' => \Modules\Participant\Entities\Participant::latest(),
            'color' => 'primary',
            'icon' => 'fa-user-group'
        ])
    </div>
@endsection

@section('content')
    <div class="container-fluid"></div>
@endsection
