@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" nonce="{{ csp_nonce('style') }}">

    @isset($reorder)
        <link rel="stylesheet" href="{{ basset_url('argon/vendor/datatables.net/rowreorder/dataTables.rowReorder.min.css') }}" nonce="{{ csp_nonce('style') }}">
    @endisset
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/datatables.net/js/jquery.dataTables.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    <script src="{{ basset_url('argon/vendor/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>

    @isset($reorder)
        <script src="{{ basset_url('argon/vendor/datatables.net/rowreorder/dataTables.rowReorder.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    @endisset
@endpush

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        const dt = $('#table{{ $name }}').DataTable({
            @isset($reorder)
            rowReorder: {
                dataSrc: 'position'
            },
            @endisset
            scrollX: true,
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ $route }}",
                data: {!! json_encode(request()->query()) !!},
                beforeSend: function() {
                    $('.dataTables_paginate, .dataTables_length, .dataTables_filter').addClass('pe-none opacity-5');
                },
                complete: function(data) {
                    $('.dataTables_paginate, .dataTables_length, .dataTables_filter').removeClass('pe-none opacity-5');

                    window.listenFormNeedConfirmation();

                    $('[data-toggle="tooltip"]').tooltip();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (errorThrown == 'Unauthorized') {
                        window.location = "{{ route('login') }}";
                    } else {
                        alert(errorThrown);
                        window.location = "{{ route('home') }}";
                    }
                },
            },
            language: {
                paginate: {
                    previous: "<i class='fas fa-angle-left'>",
                    next: "<i class='fas fa-angle-right'>",
                },
            },
            order: [{!! json_encode($orders ?? [0, 'desc']) !!}],
            columns: {!! json_encode(array_values(array_filter($columns))) !!}
        });

        @isset($reorder)
            dt.on('row-reorder', function (e, details) {
                if (details.length) {
                    let rows = [];

                    details.forEach(function (element) {
                        var rowData = dt.row(element.node).data();

                        rows.push({
                            id: rowData['id'],
                            position: element.newPosition
                        });
                    });

                    $.ajax({
                        method: 'post',
                        url: "{{ $reorder }}",
                        data: { rows }
                    }).done(function() {
                        dt.ajax.reload();
                    });
                }
            });
        @endisset
    </script>
@endpush
