@if ($row?->{$relation}?->isNotEmpty())
    @foreach ($row->{$relation} as $item)
        @php
            $fallback ??= 'N/A';
            $title = $item?->{$label} ?: $fallback;
            $limit ??= 20;
            $tooltip ??= str($title)->length() > $limit;
            $shorten = $tooltip ? str($title)->limit($limit) : $title;
        @endphp

        @if ($allowed ?? admin()->can($gate ?? 'update', $item))
            <a @class($classes ?? []) href="{{ route($route, $item ?: ($params ?? [])) }}" title="{{ __('View More') }}">
                <span class="d-inline-block mr-2" data-placement="right" data-toggle="{{ !$tooltip ?: 'tooltip' }}" title="{{ $tooltip ? $title : '' }}">{{ $shorten }}</span>
                <i class="fas fa-arrow-up-right-from-square"></i>
            </a>
        @else
            <span @class($classes ?? []) data-placement="right" data-toggle="{{ !$tooltip ?: 'tooltip' }}" title="{{ $tooltip ? $title : '' }}">{{ $shorten }}</span>
        @endif
        <br>
    @endforeach
@endif
