@php
    $limit ??= 20;
    $tooltip ??= str($title)->length() > $limit;
    $shorten = $tooltip ? str($title)->limit($limit) : $title;
@endphp

<span @class($classes ?? []) data-toggle="{{ !$tooltip ?: 'tooltip' }}" data-placement="right" title="{{ $tooltip ? $title : '' }}">
    @if ($strike ?? false)
        <s>{{ $shorten }}</s>
    @else
        {{ $shorten }}
    @endif
    @if ($tooltip)
        <i class="fas fa-comment-alt-dots ml-2"></i>
    @endif
</span>
