<div class="d-flex align-items-center">
    @if (isset($copy_text) && isset($copy_title))
        <button type="button" data-copy="{{ $copy_text }}" title="{{ $copy_title }}" class="btn-copy table-action border-0 bg-transparent px-0 text-dark mr-2">
            <i class="fas fa-copy"></i>
        </button>
    @endif

    @isset ($show_route)
        @if (admin()->can($show_gate ?? 'view', $row))
            <a href="{{ route($show_route, $params = ($row->slug ?: ($row->hash_id ?: $row->id))) }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Show" title="Show" target="{{ $show_target ?? '_blank' }}">
                <i class="fas fa-eye"></i>
            </a>
        @endif
    @endisset

    @isset ($external_route)
        <a href="{{ $external_route }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Open" title="Open" target="{{ $external_target ?? '_blank' }}">
            <i class="fas fa-arrow-up-right-from-square"></i>
        </a>
    @endisset

    @isset ($update_route)
        @if ($allowed_update ?? admin()->can($update_gate ?? 'update', $row))
            <a href="{{ route($update_route, $params ??= ($row->hash_id ?: $row->id)) }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Edit" title="Edit">
                <i class="fas fa-edit"></i>
            </a>
        @endif
    @endisset

    @isset ($gallery_route)
        <a href="{{ route($gallery_route, $params ??= ($row->hash_id ?: $row->id)) }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Gallery" title="Gallery">
            <i class="fas fa-photo-film"></i>
        </a>
    @endisset

    @isset ($schedule_route)
        <a href="{{ route($schedule_route, $params ??= ($row->hash_id ?: $row->id)) }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Schedule" title="Schedule">
            <i class="fas fa-clock"></i>
        </a>
    @endisset

    @isset ($participants_route)
        <a href="{{ route($participants_route, $params ??= ($row->hash_id ?: $row->id)) }}" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Participants" title="Participants">
            <i class="fas fa-user-group"></i>
        </a>
    @endisset

    @isset ($delete_route)
        @if ($allowed_delete ?? admin()->can($delete_gate ?? 'delete', $row))
            <form action="{{ route($delete_route, $params ??= ($row->hash_id ?: $row->id)) }}" class="need-confirm" method="post">
                @method('delete')
                @csrf
                <button type="submit" class="table-action table-action-delete border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" data-original-title="Delete" title="Delete">
                    <i class="fas fa-trash"></i>
                </button>
            </form>
        @endif
    @endisset

    @isset ($restore_route)
        @if (admin()->can($restore_gate ?? 'restore', $row))
            <form action="{{ route($restore_route, $row->id) }}" class="need-confirm" method="post">
                @csrf
                <button type="submit" class="table-action border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" data-original-title="Restore" title="Restore">
                    <i class="fas fa-arrow-rotate-left"></i>
                </button>
            </form>
        @endif
    @endisset

    @if (($unread ?? false) && !$row->has_read)
        <span class="badge badge-pill badge-info align-top ml-2">{{ __('New') }}</span>
    @endif
</div>
