@foreach ($editors ?? ['Editor' => 'editor'] as $label => $editor)
    <div class="col-12 form-group">
        <label class="form-control-label" for="input-{{ $editor }}">{{ str_replace('*', '', $label) }} @if (str_contains($label, '*')) <sup class="text-danger">*</sup> @endif</label>
        <div class="{{ $errors->has($editor) ? 'has-danger' : '' }}">
            <textarea name="{{ $editor }}" id="{{ $editor }}{{ $append ?? '' }}" class="tinymce-editor form-control {{ $errors->has($editor) ? 'is-invalid' : '' }}" placeholder="Content Here">{{ old($editor, optional($model)->{$editor}) }}</textarea>
        </div>
        @include('alerts.feedback', ['field' => $editor])
    </div>
@endforeach

@pushOnce('vendor-js')
    <script src="{{ basset_url('argon/vendor/tinymce/tinymce.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endPushOnce

@pushOnce('js')
    {{-- @bassetBlock('admin/js/tinymce-configs.js') --}}
        <script nonce="{{ basset_nonce('script') }}">
            function initTinyMCE(append = '') {
                tinymce.init({
                    @if (count($editors ?? []) > 1)
                        selector: '.tinymce-editor' + append,
                    @else
                        selector: 'textarea#' + "{{ implode(',textarea#', $editors ?? ['editor']) }}" + append,
                    @endif
                    height: 500,
                    fontsize_formats: '12px 14px 16px 18px 24px 36px 48px 54px',
                    plugins: 'advlist link image lists code',
                    // content_css: [
                    //     '{{ asset('css/icons.css') }}',
                    //     '{{ asset('css/front/app.css') }}',
                    // ],
                    toolbar: 'undo redo | styleselect | bold italic | link image | alignleft aligncenter alignright alignjustify | outdent indent code | bullist numlist',
                    valid_elements: '*[*]',
                    valid_children: '+a[div|h1|h2|h3|h4|h5|h6|p|#text]',
                    forced_root_block: false, // Disables wrapping content in <p> tags
                    force_br_newlines: true, // Forces newlines to use <br>
                    force_p_newlines: false, // Prevents <p> tags
                    newline_behavior: 'linebreak',
                    image_title: true,
                    file_picker_types: 'image',
                    convert_urls: false,
                    image_dimensions: false,
                    image_class_list: [
                        {'title': 'Responsive', 'value': 'img-fluid'},
                        {'title': 'Full Width', 'value': 'w-100'}
                    ],
                    file_picker_callback: function (callback, value, meta) {
                        tinymce.activeEditor.windowManager.openUrl({
                            title: 'File Manager',
                            url: '{{ route('elfinder.tinymce5') }}',
                            /**
                             * On message will be triggered by the child window
                             *
                             * @param dialogApi
                             * @param details
                             * @see https://www.tiny.cloud/docs/ui-components/urldialog/#configurationoptions
                             */
                            onMessage: function (dialogApi, details) {
                                if (details.mceAction === 'fileSelected') {
                                    const file = details.data.file;

                                    // Make file info
                                    const info = file.name;

                                    // Provide file and text for the link dialog
                                    if (meta.filetype === 'file') {
                                        callback(file.url, {text: info, title: info});
                                    }

                                    // Provide image and alt text for the image dialog
                                    if (meta.filetype === 'image') {
                                        callback(file.url, {alt: info});
                                    }

                                    // Provide alternative source and posted for the media dialog
                                    if (meta.filetype === 'media') {
                                        callback(file.url);
                                    }

                                    dialogApi.close();
                                }
                            }
                        });
                    },
                });
            }

            initTinyMCE();
        </script>
    {{-- @endBassetBlock() --}}
@endPushOnce
