<div class="{{ $classes ?? 'col-xl-4 col-sm-6 mb-4' }}">
    <a href="{{ route($route, $params ?? null) }}" role="button" class="card card-stats mb-0 h-100 text-decoration-none shadow">
        <div class="card-body d-flex flex-column">
            <div class="row mb-auto">
                <div class="col">
                    <h5 class="card-title text-uppercase text-muted mb-0">{{ $label }}</h5>
                    <span class="h2 font-weight-bold mb-0">{{ $count ??= $query?->count() }}</span>
                </div>
                <div class="col-auto">
                    <div class="icon icon-shape bg-{{ $color ?? collect(['success', 'danger', 'warning', 'info', 'primary'])->random() }} text-white rounded-circle shadow">
                        <i class="fas {{ $icon }} text-white"></i>
                    </div>
                </div>
            </div>
            <p class="mt-3 mb-0 text-muted text-sm text-nowrap">
                @if ($count && $query?->first()->created_at)
                    {{ __('Last created since :time', ['time' => $query->first()->created_at->diffForHumans()]) }}
                @else
                    N/A
                @endif
            </p>
        </div>
    </a>
</div>
