@component('admin.components.card')
    @isset($title)
        @slot('title', $title)
    @endisset

    @isset($class)
        @slot('class', $class)
    @endisset

    @isset($modal)
        @slot('modal', $modal)
    @endisset

    <form id="{{ $id ?? '' }}" action="@isset($route) {{ $route }} @endisset" method="post" autocomplete="off" enctype="multipart/form-data">
        @isset($edit)
            @method('put')
        @endisset
        @csrf

        <div class="row">
            {{ $slot }}
        </div>

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success">
                @isset($button)
                    {{ $button }}
                @else
                <i class="fas fa-save mr-2"></i>@isset($edit) {{ __('Update') }} @else {{ __('Create') }} @endisset
                @endisset
            </button>
        </div>
    </form>
@endcomponent
