<div class="card-header pb-3">
    <div id="filterDropdown" class="dropdown">
        <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false" data-offset="0,10">
            <i class="fas fa-filter"></i>
            <span class="mr-2">{{ __('Filter') }}</span>
        </button>
        <div class="dropdown-menu pt-1" style="min-width: 300px;">
            @if ($range ?? true)
                <div class="px-3 py-2">
                    <label class="form-control-label" for="filterDateRange">{{ __('Filter Date Range by Created At') }}</label>
                    <div class="input-group flatpickr-date">
                        <input type="date" name="range" id="filterDateRange" class="form-control" placeholder="{{ __('Date Range') }}" data-input>
                        <div class="input-group-append">
                            <button class="btn btn-outline-danger" type="button" data-clear>
                                <i class="fas fa-xmark fa-lg"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @endif

            @isset($status)
                <div class="px-3 py-2">
                    <label class="form-control-label" for="filterStatus">{{ __('Filter Status') }}</label>
                    <select class="form-control" name="status" id="filterStatus" data-toggle="select">
                        <option value="all">{{ __('All') }}</option>
                        @foreach ((is_array($status) ? $status : ['active', 'inactive']) as $label)
                            <option value="{{ $label }}" @selected(request()->query('status') == $label)>{{ ucwords($label) }}</option>
                        @endforeach
                    </select>
                </div>
            @endisset

            {{ $slot }}

            <div class="px-3 pt-3 pb-2 d-flex">
                <button id="filterReset" type="button" class="col btn btn-danger">{{ __('Reset Filter') }}</button>
                <button id="filterClose" type="button" class="col btn btn-dark">{{ __('Close Filter') }}</button>
            </div>
        </div>
    </div>
</div>

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.css') }}" nonce="{{ csp_nonce('style') }}">
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}" nonce="{{ csp_nonce('style') }}">
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        let filterClosable = true;

        $('#filterDropdown').on({
            "shown.bs.dropdown": function() { filterClosable = false; },
            "hide.bs.dropdown": function() { return filterClosable; },
        });

        @if ($range ?? true)
            const flatpikr = $(".flatpickr-date").flatpickr({
                wrap: true,
                mode: "range",
                @if (request()->query('range'))
                    defaultDate: {!! json_encode(explode(' to ', request()->query('range'))) !!},
                @endif
            });

            flatpikr.config.onClose.push(function(selectedDates, dateStr, instance) {
                if (dateStr) {
                    const urlParams = new URLSearchParams(window.location.search);
                    urlParams.set('range', dateStr);
                    window.location.search = urlParams;
                }
            });

            flatpikr.config.onChange.push(function(selectedDates, dateStr, instance) {
                if (!dateStr) {
                    const urlParams = new URLSearchParams(window.location.search);
                    urlParams.delete('range');
                    window.location.search = urlParams;
                }
            });
        @endif

        @isset($status)
            $("#filterStatus").on('change', function (ev) {
                const urlParams = new URLSearchParams(window.location.search);

                if ($(this).val() != 'all') {
                    urlParams.set('status', $(this).val());
                } else {
                    urlParams.delete('status');
                }

                window.location.search = urlParams;
            });
        @endisset

        $("#filterReset").on('click', function (ev) {
            window.history.replaceState(null, null, window.location.pathname);
            window.location.reload();
        });

        $("#filterClose").on('click', function (ev) {
            filterClosable = true;
        });
    </script>
@endpush
