<div class="col-12">
    <div class="row">
        @if (count($thumbnail ??= []))
            <div class="position-relative {{ $thumbnail['class'] ?? 'col-sm-5 col-md-4 col-lg-3 col-xl-2 mb-4 form-group' }}">
                @if ($thumbnail['delete'] ?? false)
                    <button type="button" class="btn btn-danger btn-sm btn-delete-image position-absolute m-2"
                        data-name="{{ $name }}"
                        data-label="{{ $thumbnail['label'] }}"
                        data-path="{{ $thumbnail['path'] }}"
                        data-policy="{{ $thumbnail['policy'] }}"
                        data-entity="{{ $thumbnail['entity'] }}"
                        data-column="{{ $thumbnail['column'] ?? '' }}"
                        data-hash="{{ $thumbnail['hash'] ?? '' }}"
                        data-disk="{{ $thumbnail['disk'] ?? '' }}"
                        data-placement="right" data-toggle="tooltip" data-original-title="Delete" title="Delete"
                    >
                        <i class="fas fa-trash-alt"></i>
                    </button>
                @endif
                @if ($thumbnail['show'] ?? false)
                    <a role="button" href="{{ $thumbnail['show'] }}" class="btn btn-primary btn-sm position-absolute m-2" target="_blank"
                        data-placement="right" data-toggle="tooltip" data-original-title="Show" title="Show"
                    >
                        <i class="fas fa-eye"></i>
                    </a>
                @endif
                <img src="{{ $thumbnail['url'] }}" @class(['img-thumbnail w-100', 'p-4' => $thumbnail['padding'] ?? false]) class="" alt="{{ ucwords($thumbnail['label'] ?? 'thumbnail') }}">
            </div>
        @endif
        <div class="col">
            <div class="form-group">
                <label class="form-control-label" for="{{ $name }}">
                    {{ $label }}
                    @if ($required ?? false)
                    <sup class="text-danger">*</sup>
                    @endif
                </label>
                <small class="form-text text-muted mt-0">
                    {!! __('Only <strong>:mimes</strong> extension allowed with maximum of <strong>:maxsize</strong> in file size', ['mimes' => $mimes ?? 'PNG, JPEG, JPG', 'maxsize' => in_filesize($maxsize ?? config('app.max_file_size'))]) !!}
                </small>
                @if ($recommend ?? false)
                    <small class="form-text text-muted mt-1">
                        {!! __('Recommended size: <strong>:size</strong>', ['size' => $recommend]) !!}
                    </small>
                @endif
                <div class="input-group mt-3">
                    @if ($elfinder ?? admin_dashboard())
                        <div class="input-group-prepend">
                            <button class="btn btn-primary" type="button" id="{{ $name }}ElFinderOpen">
                                <i class="fas fa-folder-open"></i>
                            </button>
                        </div>
                    @endif
                    <div class="custom-file {{ $errors->has($name) ? 'has-danger' : '' }}">
                        <input type="file" name="{{ $name }}" class="file-upload custom-file-input {{ $errors->has($name) ? 'is-invalid' : '' }}" id="{{ $name }}ElFinderFileInput" accept="{{ ($mimes ?? false) ? '*' : 'image/*'}}">
                        <label class="custom-file-label" for="{{ $name }}ElFinderFileInput">{{ __('Select :label', ['label' => $label]) }}</label>
                    </div>
                </div>
                @if (count($uploaded ??= []))
                    <a id="{{ $name }}UploadedFilePath" href="{{ $uploaded['url'] }}" class="d-block mt-2" target="_blank">{{ $uploaded['path'] }}</a>
                @endif
                @include('alerts.feedback', ['field' => $name])
            </div>
        </div>
    </div>
</div>

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $(document).ready(function() {
            @if ($elfinder ?? admin_dashboard())
                $('#{{ $name }}ElFinderOpen').on('click', function (e) {
                    window.open("{{ route('elfinder.tinymce5', ['id' => $name]) }}", '_blank', 'menubar=no,status=no,toolbar=no,scrollbars=yes,height=500,width=1000');
                });
            @endif

            $('#{{ $name }}ElFinderFileInput').on('change', function (e) {
                $(this).parent().find('input[type=hidden]').remove();
            });
        });
    </script>
@endPush

@pushOnce('js')
    <script nonce="{{ csp_nonce('script') }}">
        $(document).ready(function() {
            if ($('.btn-delete-image').length) {
                $('.btn-delete-image').on('click', function (e) {
                    const $this = $(this);

                    if (confirm("{{ __('Are you sure to proceed with this action?') }}")) {
                        $this.html('<i class="fas fa-arrows-rotate fa-spin"></i>').prop('disabled', true);

                        const name = $this.data('name');
                        const label = $this.data('label');
                        const path = $this.data('path');
                        const policy = $this.data('policy');
                        const entity = $this.data('entity');
                        const column = $this.data('column');
                        const hash = $this.data('hash');
                        const disk = $this.data('disk');

                        $.ajax({
                            url: "{{ route('destroy.image') }}",
                            method: 'delete',
                            data: {
                                label,
                                path,
                                policy,
                                entity,
                                column,
                                hash,
                                disk,
                            },
                            success: function (response) {
                                alert(response['message']);

                                if (response['status']) {
                                    $this.parent().remove();
                                }

                                if ($(`#${name}UploadedFilePath`).length) {
                                    $(`#${name}UploadedFilePath`).remove();
                                }
                            },
                            error: function (response) {
                                $this.html('<i class="fas fa-trash-alt"></i>').prop('disabled', false);
                                alert("{{ __('Unable to delete. Please try again.') }}");
                            }
                        });
                    }
                });
            }
        });
    </script>
@endPushOnce
