@inject('banner', App\Model\Banner::class)

@extends('admin.layouts.base', [
    'title' => __('Banners Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-images fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('banner.index') }}">{{ __('Banners') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('banner.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableBanner" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @can('restore', $banner)
                            <th>{{ __('Actions') }}</th>
                        @endcan
                        <th>{{ __('Thumbnail') }}</th>
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Banner',
    'route' => route('banner.index'),
    'orders' => [4, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $banner, can: ['update', 'delete']),
        get_dt_column_config('thumbnail', orderable: false, searchable: false),
        get_dt_column_config('title'),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
