@inject('banner', App\Model\Banner::class)

@extends('admin.layouts.base', [
    'title' => __('Banners Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-images fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('banner.index') }}">{{ __('Banners') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @can('create', $banner)
            @slot('buttons')
                <a href="{{ route('banner.create') }}" class="btn btn-sm btn-neutral">{{ __('Add New') }}</a>
            @endslot
        @endcan
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
        @endcomponent

        <div class="py-4">
            <table id="tableBanner" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>{{ __('Position') }}</th>
                        <th>#</th>
                        @canany(['update', 'delete'], $banner)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Thumbnail') }}</th>
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Banner',
    'route' => route('banner.index'),
    'reorder' => route('banner.reorder'),
    'orders' => [5, 'desc'],
    'columns' => [
        get_dt_column_config('position', searchable: false, class: 'reorder'),
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $banner, can: ['update', 'delete']),
        get_dt_column_config('thumbnail', orderable: false, searchable: false),
        get_dt_column_config('title'),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
