@extends('admin.layouts.base', [
    'title' => __('Edit Banner'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-images fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('banner.index') }}">{{ __('Banners') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('banner.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Banner'). ' #' . $banner->id)
                    @slot('route', route('banner.update', $banner))

                    <div class="col-12 form-group">
                        <label class="form-control-label" for="input-title">{{ __('Title') }}</label>
                        <div class="{{ $errors->has('title') ? 'has-danger' : '' }}">
                            <input type="text" name="title" id="input-title" class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" placeholder="{{ __('Title') }}" value="{{ old('title', $banner->title) }}">
                        </div>
                        @include('alerts.feedback', ['field' => 'title'])
                    </div>

                    <div class="col-md-8 col-lg-6 form-group mx-auto">
                        <img src="{{ $banner->image_path }}" class="img-thumbnail" alt="avatar">
                    </div>

                    @include('admin.components.fileinput', ['label' => 'New Banner', 'name' => 'banner'])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
