@inject('audit_login', App\Model\AuditLogin::class)

@extends('admin.layouts.base', [
    'title' => __('Audit Logins Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-pager fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('audit-login.index') }}">{{ __('Audit Logins') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            <div class="px-3 py-2">
                <label class="form-control-label" for="filterResult">{{ __('Filter Result') }}</label>
                <select class="form-control" name="result" id="filterResult" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    <option value="success" @selected(request()->query('result') == 'success')>{{ __('Success') }}</option>
                    <option value="failed" @selected(request()->query('result') == 'failed')>{{ __('Failed') }}</option>
                </select>
            </div>
            <div class="px-3 py-2">
                <label class="form-control-label" for="filterUser">{{ __('Filter User') }}</label>
                <select class="form-control" name="user" id="filterUser" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($users as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('user') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableAuditLogin" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $audit_login)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('User ID') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('IP Address') }}</th>
                        <th>{{ __('Remember Me?') }}</th>
                        <th>{{ __('Result') }}</th>
                        <th>{{ __('Throttle Hits') }}</th>
                        <th>{{ __('Created At') }}</th>
                        {{-- <th>{{ __('Updated At') }}</th> --}}
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'AuditLogin',
    'route' => route('audit-login.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $audit_login, can: ['update', 'delete']),
        get_dt_column_config('user', 'user_id', searchable: false),
        get_dt_column_config('email'),
        get_dt_column_config('ip_address'),
        get_dt_column_config('remember', 'has_remember_me', searchable: false),
        get_dt_column_config('result', 'has_failed', searchable: false),
        get_dt_column_config('throttle_hits'),
        get_dt_column_config('created_at', searchable: false),
        // get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterResult").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('result', $(this).val());
            } else {
                urlParams.delete('result');
            }

            window.location.search = urlParams;
        });

        $("#filterUser").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('user', $(this).val());
            } else {
                urlParams.delete('user');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
