<?php

namespace Database\Seeders;

use App\Model\StaticPage;
use Illuminate\Database\Seeder;

class StaticPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        StaticPage::insert([
            [
                'id' => StaticPage::TNC_ID[0],
                'title' => 'Terms & Conditions',
                'slug' => StaticPage::TNC_ID[1],
                'icon' => 'file-alt',
                'position' => 3,
                'on_menu' => 0,
                'on_footer' => 0,
                'editor_content' => 'Terms & Conditions Contents',
                'plain_content' => 'Terms & Conditions Contents',
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'id' => StaticPage::PRIVACY_ID[0],
                'title' => 'Privacy Policy',
                'slug' => StaticPage::PRIVACY_ID[1],
                'icon' => 'user-shield',
                'position' => 4,
                'on_menu' => 0,
                'on_footer' => 0,
                'editor_content' => 'Privacy Policy Contents',
                'plain_content' => 'Privacy Policy Contents',
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'id' => StaticPage::CONTACT_US_ID[0],
                'title' => 'Contact Us',
                'slug' => StaticPage::CONTACT_US_ID[1],
                'icon' => 'phone',
                'position' => 2,
                'on_menu' => 0,
                'on_footer' => 0,
                'editor_content' => 'Contact Us Contents',
                'plain_content' => 'Contact Us Contents',
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'id' => StaticPage::ABOUT_US_ID[0],
                'title' => 'About Us',
                'slug' => StaticPage::ABOUT_US_ID[1],
                'icon' => 'info-circle',
                'position' => 1,
                'on_menu' => 0,
                'on_footer' => 0,
                'editor_content' => 'About Us Contents',
                'plain_content' => 'About Us Contents',
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }
}
