<?php

use Database\Seeders\ContentBlockSeeder;
use Database\Seeders\FakerSeeder;
use Database\Seeders\SettingSeeder;
use Database\Seeders\StaticPageSeeder;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Admin\Database\Seeders\AdminDatabaseSeeder;
use Modules\Country\Database\Seeders\CountryDatabaseSeeder;
use Modules\User\Database\Seeders\UserDatabaseSeeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        $this->call([
            AdminDatabaseSeeder::class,
            // SettingSeeder::class,
            StaticPageSeeder::class,
            // ContentBlockSeeder::class,
            // CountryDatabaseSeeder::class,
            // UserDatabaseSeeder::class,
            FakerSeeder::class,
        ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
