<?php

use App\Model\StaticPage;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('static_pages', function (Blueprint $table) {
            $table->bigInteger('parent_id')->nullable()->after('id');
            $table->integer('on_menu_position')->default(0)->after('on_menu');
            $table->string('on_footer_section')->nullable()->after('on_footer');
            $table->after('is_active', function (Blueprint $table) {
                $table->string('page_type')->default(StaticPage::TYPE_INNER_PAGE);
                $table->string('page_url')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('static_pages', function (Blueprint $table) {
            $table->dropColumn([
                'parent_id',
                'on_menu_position',
                'on_footer_section',
                'page_type',
                'page_url',
            ]);
        });
    }
};
