<?php

declare(strict_types=1);

return [
    /*
     * ------------------------------------------------------------------------
     * Default Firebase project
     * ------------------------------------------------------------------------
     */

    'default' => env('FIREBASE_PROJECT', 'app'),

    'topic' => env('FIREBASE_TOPIC', 'ifsb-app'),

    /*
     * ------------------------------------------------------------------------
     * Firebase project configurations
     * ------------------------------------------------------------------------
     */

    'projects' => [
        'app' => [

            /*
             * ------------------------------------------------------------------------
             * Credentials / Service Account
             * ------------------------------------------------------------------------
             *
             * In order to access a Firebase project and its related services using a
             * server SDK, requests must be authenticated. For server-to-server
             * communication this is done with a Service Account.
             *
             * If you don't already have generated a Service Account, you can do so by
             * following the instructions from the official documentation pages at
             *
             * https://firebase.google.com/docs/admin/setup#initialize_the_sdk
             *
             * Once you have downloaded the Service Account JSON file, you can use it
             * to configure the package.
             *
             * If you don't provide credentials, the Firebase Admin SDK will try to
             * auto-discover them
             *
             * - by checking the environment variable FIREBASE_CREDENTIALS
             * - by checking the environment variable GOOGLE_APPLICATION_CREDENTIALS
             * - by trying to find Google's well known file
             * - by checking if the application is running on GCE/GCP
             *
             * If no credentials file can be found, an exception will be thrown the
             * first time you try to access a component of the Firebase Admin SDK.
             *
             */

            // 'credentials' => env('FIREBASE_CREDENTIALS', env('GOOGLE_APPLICATION_CREDENTIALS')),
            'credentials' => [
                'type' => 'service_account',
                'project_id' => 'ifsb-app',
                'private_key_id' => '127db87ac4b3816fe9aa6a098991908751dd487f',
                'private_key' => "-----BEGIN PRIVATE KEY-----\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDiLusS08Gu6mJK\nBrK+F3B5vWPmHz+PXI79oJCKhi23MUrPK111RaoBeEQYAly5bEVC4g1zK73c2RCv\ntFN3VgPzREYA28zlfyNPMkHOxv6SYRm6SOE76hNc4fN7YKPjXis09kKaHL99axbU\ngrdVFUnJSWRJVFkfnzzTcXAtlxBn2KVPhuBSeFwgSt4/u12ImxRBe4LuM/kWoiK9\niLdqyjeLpfC9eAYSKcg+lf/t/Uc4SLp3YbEHAC3GRSlyOmXndnfCTk0Ythz91viT\n4nPisDF4bI+XVhA6K/gMZa6Tf6gAtLs+7LmrUsxSyfQujq9+7qT+mKZ/mFKPjCax\nUG7SIR8NAgMBAAECggEAH2UKdVyLKm+XdlWjrcWsc67EFQcKrX2CzirhT+OmqMzg\nvgzI4M7rSrTveV2qkoTiwDvcSLuDk7SqykNUv+BilVD0CTPOfEm/aZi85aoICo1h\nItLxiygcc+yw/SkW1n0VsOOVrwqFJzAcGnc3t0md1PX+Q5IU+idXgV83hjx3pyd6\nMpG2pVArvOEoUbPollkgeuNxG255OguQcIhH89uIDGSFggNtqUV+ZAeqaRY4HK5a\nUCLhtO0ckQs3u348Blk/pJjSPUSPNAbEz+lr5vvbt1ZwYpd6ifyMEg37PY+ba/hF\njNkWFfkLDOmt8UafprCNBCGuKd9y6wPM1StxV3JiiQKBgQD+jBoC9Sd9yxY55s68\nkcr4rskvW047ZozEzMHJeCA5E8RyLpkSOtsyLhfXqaS+sW5yXXZ9LJUViKN2FQKV\nyNiZkfdNi8+A5TR7SNmfUiBSE7Pta6YqcJcXoxkbowRaCmiXwEKgoWQt8yxgIdYZ\nqAIFto7Z5zMTSFICFLBTkrW1mwKBgQDjeWBV2/OTY4hvNaCsm5WC2rlX5uKu3tVg\nc6yX8QcNr5rl1/U7Q9QG8lw+MlrJ2Poquc7IiwjMiK77DOazt5SZme9a71ajzzjR\n8cLMj5fYZjfAB1TMNjxu+z40K15nK66v8vLifPuqpQzFqmUlU+N+X5VDdi99/BYI\nES68QJJcdwKBgFyYWl35EASSe+NUMqAl6M/NxSGU9UBmbY6pbVT8fbxFlJB0ovoe\nrt3yJnotG+DCaorvtMqUDSdoLQ4nVmlmRmSW1H9A/JrGxfCS75clKNyyjiEvp6KI\nkm3mxptnEY4vexy4s4P7MZYFf3740AlFNHcfkZdyowHArRRUsk+0bqVBAoGAJW8X\nBGoi5nFtxWdc3qrn6tXVxHpxeXegQ7QlhgebMoxggEyOxcb+wHnn5jBhMnBrktZr\nCiOfOhGQQi44VQD0CmcDtcJHTsPORPZ1KTbENU91Azvxn32ZamYcMXelnHLa14ey\nosUQoV9x/6Fv7bmlaWmPZb+wRxpSAdfaCg7SRzcCgYAZfmzXlh60gAw0FEZ1uL3x\nvwn4557tA4I7NWTHR0s1YOyaZ2Xek0Fg/y8Iy3/pB0CHdi/aeInHNa0Bag+J4znN\nnfcrOSP64xKYYYEtGOegC4sEY02w7GV8SqvUnTA8SQul51XpS+8Cop5l7CJLeuc4\nh7rN8Qkz27SRMsj6YsZQ8Q==\n-----END PRIVATE KEY-----\n",
                'client_email' => 'firebase-adminsdk-fbsvc@ifsb-app.iam.gserviceaccount.com',
                'client_id' => '112733454984651471791',
                'auth_uri' => 'https://accounts.google.com/o/oauth2/auth',
                'token_uri' => 'https://oauth2.googleapis.com/token',
                'auth_provider_x509_cert_url' => 'https://www.googleapis.com/oauth2/v1/certs',
                'client_x509_cert_url' => 'https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-fbsvc%40ifsb-app.iam.gserviceaccount.com',
                'universe_domain' => 'googleapis.com',
            ],

            /*
             * ------------------------------------------------------------------------
             * Firebase Auth Component
             * ------------------------------------------------------------------------
             */

            'auth' => [
                'tenant_id' => env('FIREBASE_AUTH_TENANT_ID'),
            ],

            /*
             * ------------------------------------------------------------------------
             * Firestore Component
             * ------------------------------------------------------------------------
             */

            'firestore' => [

                /*
                 * If you want to access a Firestore database other than the default database,
                 * enter its name here.
                 *
                 * By default, the Firestore client will connect to the `(default)` database.
                 *
                 * https://firebase.google.com/docs/firestore/manage-databases
                 */

                // 'database' => env('FIREBASE_FIRESTORE_DATABASE'),
            ],

            /*
             * ------------------------------------------------------------------------
             * Firebase Realtime Database
             * ------------------------------------------------------------------------
             */

            'database' => [

                /*
                 * In most of the cases the project ID defined in the credentials file
                 * determines the URL of your project's Realtime Database. If the
                 * connection to the Realtime Database fails, you can override
                 * its URL with the value you see at
                 *
                 * https://console.firebase.google.com/u/1/project/_/database
                 *
                 * Please make sure that you use a full URL like, for example,
                 * https://my-project-id.firebaseio.com
                 */

                'url' => env('FIREBASE_DATABASE_URL'),

                /*
                 * As a best practice, a service should have access to only the resources it needs.
                 * To get more fine-grained control over the resources a Firebase app instance can access,
                 * use a unique identifier in your Security Rules to represent your service.
                 *
                 * https://firebase.google.com/docs/database/admin/start#authenticate-with-limited-privileges
                 */

                // 'auth_variable_override' => [
                //     'uid' => 'my-service-worker'
                // ],

            ],

            'dynamic_links' => [

                /*
                 * Dynamic links can be built with any URL prefix registered on
                 *
                 * https://console.firebase.google.com/u/1/project/_/durablelinks/links/
                 *
                 * You can define one of those domains as the default for new Dynamic
                 * Links created within your project.
                 *
                 * The value must be a valid domain, for example,
                 * https://example.page.link
                 */

                'default_domain' => env('FIREBASE_DYNAMIC_LINKS_DEFAULT_DOMAIN'),
            ],

            /*
             * ------------------------------------------------------------------------
             * Firebase Cloud Storage
             * ------------------------------------------------------------------------
             */

            'storage' => [

                /*
                 * Your project's default storage bucket usually uses the project ID
                 * as its name. If you have multiple storage buckets and want to
                 * use another one as the default for your application, you can
                 * override it here.
                 */

                'default_bucket' => env('FIREBASE_STORAGE_DEFAULT_BUCKET'),

            ],

            /*
             * ------------------------------------------------------------------------
             * Caching
             * ------------------------------------------------------------------------
             *
             * The Firebase Admin SDK can cache some data returned from the Firebase
             * API, for example Google's public keys used to verify ID tokens.
             *
             */

            'cache_store' => env('FIREBASE_CACHE_STORE', 'file'),

            /*
             * ------------------------------------------------------------------------
             * Logging
             * ------------------------------------------------------------------------
             *
             * Enable logging of HTTP interaction for insights and/or debugging.
             *
             * Log channels are defined in config/logging.php
             *
             * Successful HTTP messages are logged with the log level 'info'.
             * Failed HTTP messages are logged with the log level 'notice'.
             *
             * Note: Using the same channel for simple and debug logs will result in
             * two entries per request and response.
             */

            'logging' => [
                'http_log_channel' => env('FIREBASE_HTTP_LOG_CHANNEL'),
                'http_debug_log_channel' => env('FIREBASE_HTTP_DEBUG_LOG_CHANNEL'),
            ],

            /*
             * ------------------------------------------------------------------------
             * HTTP Client Options
             * ------------------------------------------------------------------------
             *
             * Behavior of the HTTP Client performing the API requests
             */

            'http_client_options' => [

                /*
                 * Use a proxy that all API requests should be passed through.
                 * (default: none)
                 */

                'proxy' => env('FIREBASE_HTTP_CLIENT_PROXY'),

                /*
                 * Set the maximum amount of seconds (float) that can pass before
                 * a request is considered timed out
                 *
                 * The default time out can be reviewed at
                 * https://github.com/kreait/firebase-php/blob/6.x/src/Firebase/Http/HttpClientOptions.php
                 */

                'timeout' => env('FIREBASE_HTTP_CLIENT_TIMEOUT'),

                'guzzle_middlewares' => [],
            ],
        ],
    ],
];
