<?php

namespace App\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;

class PageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'hash' => $this->hash_id,
            'slug' => $this->slug,
            'title' => $this->title,
            'content' => $this->editor_content,
            'icon' => $this->icon,
            'created_timestamp' => $this->created_at?->timestamp,
            'created_date_formatted' => $this->created_at?->format('d/m/Y'),
            'created_time_formatted' => $this->created_at?->format('h:i A'),
        ];
    }
}
