<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\Http;

class Recaptcha implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (is_null($value)) {
            $fail(__('Please completed recaptcha challenge.'));
        }

        $message = __('The recaptcha score detected a robot.');

        if (config('recaptcha.empty_message')) {
            $message = trans(config('recaptcha.error_message_key'));
        }

        $url = 'https://' . config('recaptcha.api_domain') . '/recaptcha/api/siteverify';

        $response = Http::asForm()->post($url, [
            'secret' => config('recaptcha.api_secret_key'),
            'response' => $value,
            'remoteip' => request()->ip(),
        ])->json();

        if ($response['success']) {
            //
        } else {
            $fail($message);
        }
    }
}
