<?php

namespace App\Providers;

use App\Events\BusinessClaimed;
use App\Listeners\RecordFailedLoginAttempt;
use App\Listeners\RecordSuccessLoginAttempt;
use App\Listeners\SendClaimApprovalReminderNotification;
use App\Listeners\StripeCheckoutCompleted;
use App\Listeners\StripeSubscriptionInvoiceFailed;
use App\Listeners\StripeSubscriptionInvoicePaid;
use Illuminate\Auth\Events\Authenticated;
use Illuminate\Auth\Events\Failed;
use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Login::class => [
            RecordSuccessLoginAttempt::class,
        ],
        Failed::class => [
            RecordFailedLoginAttempt::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
