<?php
namespace App\Providers;

use App\Classes\Dynamics\Client\ClientFactory;
use App\Classes\Uno;
use App\Model\Setting;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Validation\Rules\Password;
use Illuminate\View\View;
use JustBetter\DynamicsClient\Contracts\ClientFactoryContract;
use Modules\User\Entities\User;
use SocialiteProviders\Manager\SocialiteWasCalled;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Model::preventLazyLoading(!app()->isProduction());

        Paginator::useBootstrapFour();

        Password::defaults(function () {
            return Password::min(config('password.min_length', 8))
                ->letters()
                ->numbers()
                ->symbols()
                // ->uncompromised()
                ->mixedCase();
        });

        if (Schema::hasTable('settings')) {
            $settings = Setting::all();

            foreach ($settings as $setting) {
                if (in_array($setting->key, Setting::$SENSITIVE_KEYS) && ! is_null($setting->value)) {
                    Config::set($setting->key, $setting->value);
                }

                if (in_array($setting->key, Setting::$MANAGEABLE_KEYS)) {
                    Config::set($setting->key, $setting->value);
                }

                if ($setting->key == 'app.logo' && $setting->value) {
                    uno()->setLogo($setting->value);
                }
            }
        }

        Event::listen(function (SocialiteWasCalled $event) {
            // $event->extendSocialite('google', \SocialiteProviders\Google\Provider::class);
            //$event->extendSocialite('facebook', \SocialiteProviders\Facebook\Provider::class);
            // $event->extendSocialite('linkedin', LinkedIn::class);
            // $event->extendSocialite('twitter', \SocialiteProviders\Twitter\Provider::class, \SocialiteProviders\Twitter\Server::class);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // URL::forceScheme('https');

        $this->app->singleton('uno', function () {
            return new Uno();
        });
    }
}
