<?php

namespace App\Policies;

use App\Model\StaticPage;
use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class StaticPagePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the admin can see the static pages.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return $admin->hasPermission('page');
    }

    /**
     * Determine whether the admin can create static pages.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function create(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can update the static page.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\StaticPage  $static_page
     * @return boolean
     */
    public function update(Admin $admin, StaticPage $static_page = null)
    {
        return $admin->hasPermission('page');
    }

    /**
     * Determine whether the admin can delete the static page.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\StaticPage  $static_page
     * @return boolean
     */
    public function delete(Admin $admin, StaticPage $static_page)
    {
        return $admin->hasPermission('page') && !in_array($static_page->id, StaticPage::unDeletedPages());
    }

    /**
     * Determine whether the admin can restore the static page.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function restore(Admin $admin)
    {
        return $admin->hasPermission('page');
    }
}
