<?php

namespace App\Policies;

use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class SettingPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the admin can see the settings.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return $admin->hasPermission('setting');
    }

    /**
     * Determine whether the admin can update the Setting.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function update(Admin $admin)
    {
        return $admin->hasPermission('setting');
    }
}
