<?php

namespace App\Policies;

use App\Model\Banner;
use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class BannerPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the admin can see the banners.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can create banners.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function create(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can update the banner.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\Banner  $banner
     * @return boolean
     */
    public function update(Admin $admin, Banner $banner = null)
    {
        return false;
    }

    /**
     * Determine whether the admin can delete the banner.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\Banner  $banner
     * @return boolean
     */
    public function delete(Admin $admin, Banner $banner)
    {
        return false;
    }

    /**
     * Determine whether the admin can restore the banner.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function restore(Admin $admin)
    {
        return false;
    }
}
