<?php

namespace App\Policies;

use App\Model\AuditLogin;
use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class AuditLoginPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the admin can see the models.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can create models.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function create(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can update the model.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\AuditLogin  $model
     * @return boolean
     */
    public function update(Admin $admin, AuditLogin $model = null)
    {
        return false;
    }

    /**
     * Determine whether the admin can delete the model.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @param  \App\Model\AuditLogin  $model
     * @return boolean
     */
    public function delete(Admin $admin, AuditLogin $model)
    {
        return false;
    }

    /**
     * Determine whether the admin can restore the model.
     *
     * @param  \Modules\Admin\Entities\Admin  $admin
     * @return boolean
     */
    public function restore(Admin $admin)
    {
        return false;
    }
}
