<?php

namespace App\Listeners;

use App\Model\AuditLogin;
use Illuminate\Auth\Events\Failed;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Str;
use Modules\Admin\Entities\Admin;

class RecordFailedLoginAttempt
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(Failed $event): void
    {
        $ip = request()->ip();

        $user = $event->user;

        $username = isset($event->credentials['username']) ? $event->credentials['username'] : ($event->credentials['email'] ?? 'n/a');

        $throttle_key = Str::transliterate(Str::lower($username) . '|' . $ip);

        AuditLogin::create([
            'admin_id' => $user?->id,
            'email' => $username,
            'ip_address' => $ip,
            'has_remember_me' => request()->has('remember'),
            'has_failed' => true,
            'throttle_hits' => RateLimiter::attempts($throttle_key)
        ]);
    }
}
