<?php

namespace App\Http\Requests;

use App\Model\StaticPage;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StaticPageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => ['required', 'string', 'max:200'],
            // 'description' => ['nullable', 'string'],
            // 'keywords' => ['nullable', 'string', 'max:255'],
            // 'page_type' => ['required', Rule::in(array_keys(StaticPage::listPageTypes()))],
            // 'page_url' => ['nullable', Rule::requiredIf($this->get('page_type') == StaticPage::TYPE_CUSTOM_URL), 'url'],
            // 'slug' => ['nullable', Rule::requiredIf($this->get('page_type') == StaticPage::TYPE_INNER_PAGE), 'alpha_dash', Rule::unique((new StaticPage())->getTable())->ignore($this->route('static_page'))],
            'editor_content' => ['required', 'string'],
            // 'on_menu' => ['sometimes', 'boolean'],
            // 'on_footer' => ['sometimes', 'boolean'],
            // 'on_footer_section' => [
            //     'nullable',
            //     Rule::requiredIf($this->boolean('on_footer')),
            //     Rule::in(array_keys(StaticPage::listFooterSections())),
            // ],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            // 'on_footer_section' => 'footer section',
        ];
    }
}
