<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'app-logo' => file_validation($this->get('app-logo')),
            'app-name' => ['required'],
            'app-description' => ['nullable', 'string'],
            'app-keywords' => ['nullable', 'string'],
            'app-mobile-version-android' => ['required', 'string', 'regex:/^\d+\.\d+\.\d+$/'],
            'app-mobile-version-ios' => ['required', 'string', 'regex:/^\d+\.\d+\.\d+$/'],

            'app-maintenance_mode_status' => ['required', 'in:enable,disable'],
            'app-maintenance_mode_message' => ['required_if:app-maintenance_mode_status,enable', 'nullable', 'string'],

            'mail-mailers-smtp-host' => ['required'],
            'mail-mailers-smtp-port' => ['required', 'numeric'],
            'mail-mailers-smtp-encryption' => ['required'],
            'mail-mailers-smtp-username' => ['nullable'],
            'mail-mailers-smtp-password' => ['nullable'],
            'mail-from-address' => ['required', 'email'],
            'mail-from-name' => ['required'],

            'recaptcha-api_site_key' => ['nullable'],
            'recaptcha-api_secret_key' => ['nullable'],

            'admin-notification_emails' => ['required'],

            'social-facebook' => ['nullable', 'url'],
            'social-instagram' => ['nullable', 'url'],
            'social-linkedin' => ['nullable', 'url'],
            'social-youtube' => ['nullable', 'url'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'app-logo' => 'website logo',
            'app-name' => 'website title',
            'app-description' => 'website description',
            'app-keywords' => 'website keywords',
            'app-mobile-version-android' => 'android current app version',
            'app-mobile-version-ios' => 'ios current app version',

            'app-maintenance_mode_status' => 'website maintenance status',
            'app-maintenance_mode_message' => 'website maintenance message',

            'mail-mailers-smtp-host' => 'smtp host',
            'mail-mailers-smtp-port' => 'smtp port',
            'mail-mailers-smtp-encryption' => 'smtp encryption',
            'mail-mailers-smtp-username' => 'smtp account username',
            'mail-mailers-smtp-password' => 'smtp account password',
            'mail-from-address' => 'sender email address',
            'mail-from-name' => 'sender name',

            'recaptcha-api_site_key' => 'recaptcha site key',
            'recaptcha-api_secret_key' => 'recaptcha secret key',

            'admin-notification_emails' => 'admin notification emails',
        ];
    }
}
