<?php

namespace App\Http\Middleware;

use App\Classes\SecureHeaders as UnoSecureHeaders;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SecureHeaders
{
    private $unwantedHeaderList = [
        'X-Powered-By',
        'Server',
    ];

    /**
     * The URIs that should be exclude from secure headers
     *
     * @var array
     */
    protected $except = [
        'elfinder/*',
        'clockwork/*',
        '__clockwork/*',
    ];

    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     *
     * @return Response
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        if ($this->inExceptArray($request) || session()->pull('skip-secure-headers', false)) {
            return $response;
        }

        $headers = (new UnoSecureHeaders(config('secure-headers', [])))
                    ->removeStyleNonce()
                    ->headers();

        foreach ($headers as $key => $value) {
            $response->headers->set($key, $value, true);
        }

        $this->removeUnwantedHeaders();

        return $response;
    }

    private function removeUnwantedHeaders()
    {
        foreach ($this->unwantedHeaderList as $header) {
            header_remove($header);
        }
    }

    /**
     * Determine if the request has a URI that should be exclude from secure headers.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return bool
     */
    protected function inExceptArray($request)
    {
        foreach ($this->except as $except) {
            if ($except !== '/') {
                $except = trim($except, '/');
            }

            if ($request->fullUrlIs($except) || $request->is($except)) {
                return true;
            }
        }

        return false;
    }
}
