<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Foundation\Http\Middleware\Concerns\ExcludesPaths;
use Illuminate\Foundation\Http\Middleware\TransformsRequest;

class SanitizeInputs extends TransformsRequest
{
    use ExcludesPaths;

    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array
     */
    protected $except = [
        //
    ];

    public function handle($request, Closure $next)
    {
        if ($this->inExceptArray($request)) {
            return parent::handle($request, $next);
        }

        return $next($request);
    }

    protected function transform($key, $value)
    {
        return anti_xss($value);
    }
}
