<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\Response;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['auth:admin', 'admin.active']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.index');
    }

    public function destroyImage(Request $request)
    {
        $hash = $request->get('hash');
        $column = $request->get('column');
        $label = $request->get('label', 'thumbnail');
        $path = $request->get('path');
        $policy = $request->get('policy');
        $entity = $request->get('entity');
        $disk = $request->get('disk');

        abort_unless($request->ajax() && $path && $policy && $entity, Response::HTTP_FORBIDDEN);

        if ($hash) {
            if (is_numeric($hash)) {
                $model = $entity::find($hash);
            } else {
                $model = $entity::findByHashId($hash);
            }
        } else {
            $model = new $entity();
        }

        $this->authorize($policy, $model);

        $status = false;
        $message = __(':label does not exist in storage.', ['label' => ucwords($label)]);

        if (filter_var($path, FILTER_VALIDATE_URL)) {
            //
        } else {
            $disks = config('filesystems.disks');

            unset($disks['s3']);

            foreach ($disks as $disk => $config) {
                $storage = Storage::disk($disk);

                if ($storage->exists($path)) {
                    $storage->delete($path);
                    $status = true;
                    $message = __(':label has been deleted.', ['label' => ucwords($label)]);

                    break;
                }
            }
        }

        if ($status && $model->exists && $column) {
            $model->{$column} = null;
            $model->saveQuietly();
        }

        return response()->json([
            'status' => $status,
            'message' => $message
        ]);
    }
}
